	% Example 15.2  
	clear all, close all, clc
	wcT = 0.05*pi;		wsT = 0.1*pi;	dc = 0.01;	ds = 0.001;
	wT = linspace(0,pi,1000);
	% Linea-phase direct form FIR
	%	[N, Be, D, W] = HERRMANN_LP_FIR_ORDER([wcT wsT], [dc ds]);
	%	N = N+5
	%	[h0, Err] = PMR_FIR(N, Be, D, W, 'sym'); H0 = freqz(h0,1,wT);
	%	subplot(4,1,1),	 PLOT_MAGNITUDE_Z3(wT, H_2_MAG(H0), 80, 'H_0')
	%	zoom on
	
	% Kernel filter
	M = 6;			% < 2*pi/wsT
	
	[NK, Be, D, W] = HERRMANN_LP_FIR_ORDER(M*[wcT wsT], [dc/3 ds]); 
	NK = NK+1
	[hK, Err] = REMEZ_FIR(NK , Be, D, W, 'm'); 
	HK = freqz(hK,1,M*wT);
	subplot(3,1,1), PLOT_MAG_Z_dB(wT, HK, pi, 80, 'H_K')
	% Decimation filter
	dcD = dc/1.6; dsD = 1.65*sqrt(ds);
	[ND, Be, D, W] = HERRMANN_LP_FIR_ORDER([wcT 2*pi/M-wsT], [dcD dsD]); 
	ND = ND+1
	[hD, Err] = REMEZ_FIR(ND , Be, D, W, 'm'); 
 
	HD = freqz(hD,1,wT);
	subplot(3,1,2), PLOT_MAG_Z_dB(wT, HD, pi, 80, 'H_D')
	% Interpolation filter
	HI = HD;
	% Overall filter
	H = HI.*HK.*HD;
	subplot(3,1,3),  PLOT_MAG_Z_dB(wT, H, pi, 80, 'H')
	zoom on
	 
	hD = [hD 0 0 0 0]; % make the length = Integer*M
	 	
	P = reshape(hD, M, length(hD)/M)
	%Amax= H_2_MAG((1+dc)/(1-dc))
	Amax= max(H_2_MAG(H(1:50)))-min(H_2_MAG(H(1:50)))
	Amin = -max(H_2_MAG(H(101:end)))
	zoom on
	xlabel('{\it\omegaT} [rad]');
